* [Guía completa para novatos](es/newbs.md)
  * [Empezando](es/newbs_getting_started.md)
  * [Construyendo tu primer firmare](es/newbs_building_firmware.md)
  * [Flasheando el firmware](es/newbs_flashing.md)
  * [Testeando y depurando ](es/newbs_testing_debugging.md)
  * [Mejores práticas](es/newbs_best_practices.md)
  * [Recursos de aprendizaje](es/newbs_learn_more_resources.md)

* [QMK Basics](es/README.md)
  * [Introducción a QMK](es/getting_started_introduction.md)
  * [QMK CLI](es/cli.md)
  * [Configuración de QMK CLI](es/cli_configuration.md)
  * [Contribuyendo a QMK](es/contributing.md)
  * [Cómo usar GitHub](es/getting_started_github.md)
  * [Obtener ayuda](es/getting_started_getting_help.md)

* [Cambios incompatibles](es/breaking_changes.md)
  * [30 Ago 2019](es/ChangeLog/20190830.md)

* [Preguntas frecuentes](es/faq.md)
  * [General](es/faq_general.md)
  * [Construir/Compilar QMK](es/faq_build.md)
  * [Depurando/Encontrando problemas en QMK](es/faq_debug.md)
  * [Keymap](es/faq_keymap.md)
  * [Instalación de drivers con Zadig](es/driver_installation_zadig.md)

* Guías detalladas
  * [Instalar herramientas construcción](es/getting_started_build_tools.md)
  * [Guía Vagrant](es/getting_started_vagrant.md)
  * [Instrucciones de Construcción/Compilado](es/getting_started_make_guide.md)
  * [Flasheando Firmware](es/flashing.md)
  * [Personalizando funcionalidad](es/custom_quantum_functions.md)
  * [Visión general del Keymap](es/keymap.md)

* [Hardware](es/hardware.md)
  * [Procesadores AVR](es/hardware_avr.md)
  * [Drivers](es/hardware_drivers.md)

* Referencia
  * [Pautas de teclados](es/hardware_keyboard_guidelines.md)
  * [Opciones de configuración](es/config_options.md)
  * [Keycodes](es/keycodes.md)
  * [Convenciones de código - C](es/coding_conventions_c.md)
  * [Convenciones de código - Python](es/coding_conventions_python.md)
  * [Mejores prácticas de documentación](es/documentation_best_practices.md)
  * [Plantillas de documentación](es/documentation_templates.md)
  * [Glosario](es/reference_glossary.md)
  * [Tests unitarios](es/unit_testing.md)
  * [Funciones útiles](es/ref_functions.md)
  * [Sporte configurador](es/reference_configurator_support.md)
  * [Formato info.json](es/reference_info_json.md)
  * [Desarrollo Python CLI](es/cli_development.md)

* [Características](es/features.md)
  * [Keycodes Básicos](es/keycodes_basic.md)
  * [Teclas US ANSI Shifted](es/keycodes_us_ansi_shifted.md)
  * [Keycodes Quantum](es/quantum_keycodes.md)
  * [Keycodes Avanzados](es/feature_advanced_keycodes.md)
  * [Audio](es/feature_audio.md)
  * [Auto Shift](es/feature_auto_shift.md)
  * [Retroiluminación](es/feature_backlight.md)
  * [Bluetooth](es/feature_bluetooth.md)
  * [Bootmagic](es/feature_bootmagic.md)
  * [Combos](es/feature_combo.md)
  * [Comando](es/feature_command.md)
  * [API Debounce](es/feature_debounce_type.md)
  * [Switch DIP](es/feature_dip_switch.md)
  * [Macros Dinámicas](es/feature_dynamic_macros.md)
  * [Encoders](es/feature_encoders.md)
  * [Grave Escape](es/feature_grave_esc.md)
  * [Feedback Háptico](es/feature_haptic_feedback.md)
  * [Controlador LCD HD44780](es/feature_hd44780.md)
  * [Key Lock](es/feature_key_lock.md)
  * [Layouts](es/feature_layouts.md)
  * [Tecla Leader](es/feature_leader_key.md)
  * [Matriz LED](es/feature_led_matrix.md)
  * [Macros](es/feature_macros.md)
  * [Teclas del ratón](es/feature_mouse_keys.md)
  * [Driver OLED](es/feature_oled_driver.md)
  * [Teclas One Shot](es/one_shot_keys.md)
  * [Dispositivo de apuntado](es/feature_pointing_device.md)
  * [Ratón PS/2](es/feature_ps2_mouse.md)
  * [Iluminación RGB](es/feature_rgblight.md)
  * [Matriz RGB](es/feature_rgb_matrix.md)
  * [Cadete espacial](es/feature_space_cadet.md)
  * [Teclado dividido](es/feature_split_keyboard.md)
  * [Stenografía](es/feature_stenography.md)
  * [Swap Hands](es/feature_swap_hands.md)
  * [Tap Dance](es/feature_tap_dance.md)
  * [Terminal](es/feature_terminal.md)
  * [Impresora Térmica](es/feature_thermal_printer.md)
  * [Unicode](es/feature_unicode.md)
  * [Userspace](es/feature_userspace.md)
  * [Velocikey](es/feature_velocikey.md)

* Para Makers y Modders
  * [Guía de cableado a mano](es/hand_wire.md)
  * [Guía de flasheado de ISP](es/isp_flashing_guide.md)
  * [Guía de depuración de ARM](es/arm_debugging.md)
  * [Driver I2C](es/i2c_driver.md)
  * [Driver SPI](es/spi_driver.md)
  * [Controles GPIO](es/internals_gpio_control.md)
  * [Conversión Proton C](es/proton_c_conversion.md)

* Para entender en profundidad
  * [Cómo funcionan los teclados](es/how_keyboards_work.md)
  * [Entendiendo QMK](es/understanding_qmk.md)

* Otros temas
  * [Usando Eclipse con QMK](es/other_eclipse.md)
  * [Usando VSCode con QMK](es/other_vscode.md)
  * [Soporte](es/getting_started_getting_help.md)
  * [Cómo añadir traducciones](es/translating.md)

* QMK Internals (En progreso)
  * [Defines](es/internals_defines.md)
  * [Input Callback Reg](es/internals_input_callback_reg.md)
  * [Dispositivo Midi](es/internals_midi_device.md)
  * [Proceso de configuración de un dispositivo Midi](es/internals_midi_device_setup_process.md)
  * [Utilidad Midi](es/internals_midi_util.md)
  * [Funciones Send](es/internals_send_functions.md)
  * [Herramientas Sysex](es/internals_sysex_tools.md)
