* [Anleitung für Anfänger](de/newbs.md)
  * [Erste Schritte](de/newbs_getting_started.md)
  * [Die erste Firmware](de/newbs_building_firmware.md)
  * [Firmware flashen](de/newbs_flashing.md)
  * [Testen und Debuggen](de/newbs_testing_debugging.md)
  * [Git Tips und Tricks](de/newbs_best_practices.md)
  * [Hilfreiche Ressourcen](de/newbs_learn_more_resources.md)

* [QMK Basics](de/README.md)
  * [QMK Einführung](de/getting_started_introduction.md)
  * [QMK CLI](de/cli.md)
  * [QMK CLI Konfiguration](de/cli_configuration.md)
  * [Zu QMK beitragen](de/contributing.md)
  * [Anleitung für GitHub](de/getting_started_github.md)
  * [Nach Hilfe fragen](de/getting_started_getting_help.md)

* [Breaking Changes](de/breaking_changes.md)
  * [2019 Aug 30](de/ChangeLog/20190830.md)

* [FAQ](de/faq.md)
  * [Häufige Fragen](de/faq_general.md)
  * [Build/Kompilieren](de/faq_build.md)
  * [Debugging/Troubleshooting](de/faq_debug.md)
  * [Keymap](de/faq_keymap.md)
  * [Treiber Installation mit Zadig](de/driver_installation_zadig.md)

* Detailierte Guides
  * [Build Tools installieren](de/getting_started_build_tools.md)
  * [Vagrant Guide](de/getting_started_vagrant.md)
  * [Build/Compile Anleitung](de/getting_started_make_guide.md)
  * [Firmware flashen](de/flashing.md)
  * [Funktionalität anpassen](de/custom_quantum_functions.md)
  * [Keymap Überblick](de/keymap.md)

* [Hardware](de/hardware.md)
  * [AVR Prozessoren](de/hardware_avr.md)
  * [Treiber](de/hardware_drivers.md)

* Referenz
  * [Tastatur Richtlinien](de/hardware_keyboard_guidelines.md)
  * [Konfigurations Optionen](de/config_options.md)
  * [Keycodes](de/keycodes.md)
  * [Coding Konventionen - C](de/coding_conventions_c.md)
  * [Coding Konventionen - Python](de/coding_conventions_python.md)
  * [Dokumentations Best Practices](de/documentation_best_practices.md)
  * [Dokumentations Templates](de/documentation_templates.md)
  * [Glossar](de/reference_glossary.md)
  * [Unit Testing](de/unit_testing.md)
  * [Nützliche Funktionen](de/ref_functions.md)
  * [Configurator Support](de/reference_configurator_support.md)
  * [info.json Format](de/reference_info_json.md)
  * [Python CLI Development](de/cli_development.md)

* [Features](de/features.md)
  * [Basic Keycodes](de/keycodes_basic.md)
  * [US ANSI Shifted Keys](de/keycodes_us_ansi_shifted.md)
  * [Quantum Keycodes](de/quantum_keycodes.md)
  * [Advanced Keycodes](de/feature_advanced_keycodes.md)
  * [Audio](de/feature_audio.md)
  * [Auto Shift](de/feature_auto_shift.md)
  * [Backlight](de/feature_backlight.md)
  * [Bluetooth](de/feature_bluetooth.md)
  * [Bootmagic](de/feature_bootmagic.md)
  * [Combos](de/feature_combo.md)
  * [Command](de/feature_command.md)
  * [Debounce API](de/feature_debounce_type.md)
  * [DIP Switch](de/feature_dip_switch.md)
  * [Dynamic Macros](de/feature_dynamic_macros.md)
  * [Encoders](de/feature_encoders.md)
  * [Grave Escape](de/feature_grave_esc.md)
  * [Haptic Feedback](de/feature_haptic_feedback.md)
  * [HD44780 LCD Controller](de/feature_hd44780.md)
  * [Key Lock](de/feature_key_lock.md)
  * [Layouts](de/feature_layouts.md)
  * [Leader Key](de/feature_leader_key.md)
  * [LED Matrix](de/feature_led_matrix.md)
  * [Macros](de/feature_macros.md)
  * [Mouse Keys](de/feature_mouse_keys.md)
  * [OLED Driver](de/feature_oled_driver.md)
  * [One Shot Keys](de/one_shot_keys.md)
  * [Pointing Device](de/feature_pointing_device.md)
  * [PS/2 Mouse](de/feature_ps2_mouse.md)
  * [RGB Lighting](de/feature_rgblight.md)
  * [RGB Matrix](de/feature_rgb_matrix.md)
  * [Space Cadet](de/feature_space_cadet.md)
  * [Split Keyboard](de/feature_split_keyboard.md)
  * [Stenography](de/feature_stenography.md)
  * [Swap Hands](de/feature_swap_hands.md)
  * [Tap Dance](de/feature_tap_dance.md)
  * [Terminal](de/feature_terminal.md)
  * [Thermal Printer](de/feature_thermal_printer.md)
  * [Unicode](de/feature_unicode.md)
  * [Userspace](de/feature_userspace.md)
  * [Velocikey](de/feature_velocikey.md)

* Für Maker und Modder
  * [Hand Wiring Guide](de/hand_wire.md)
  * [ISP Flashing Guide](de/isp_flashing_guide.md)
  * [ARM Debugging Guide](de/arm_debugging.md)
  * [I2C Driver](de/i2c_driver.md)
  * [SPI Driver](de/spi_driver.md)
  * [GPIO Controls](de/internals_gpio_control.md)
  * [Proton C Conversion](de/proton_c_conversion.md)

* Für ein tieferes Verständnis
  * [Wie Tastaturen funktionieren](de/how_keyboards_work.md)
  * [QMK verstehen](de/understanding_qmk.md)

* Andere Themen
  * [Eclipse mit QMK](de/other_eclipse.md)
  * [VSCode mit QMK](de/other_vscode.md)
  * [Support](de/getting_started_getting_help.md)
  * [Übersetzungen](de/translating.md)

* QMK Internals (In Progress)
  * [Defines](de/internals_defines.md)
  * [Input Callback Reg](de/internals_input_callback_reg.md)
  * [Midi Device](de/internals_midi_device.md)
  * [Midi Device Setup Process](de/internals_midi_device_setup_process.md)
  * [Midi Util](de/internals_midi_util.md)
  * [Send Functions](de/internals_send_functions.md)
  * [Sysex Tools](de/internals_sysex_tools.md)
