# Quantum Mechanical Keyboard Firmware

[![Current Version](https://img.shields.io/github/tag/qmk/qmk_firmware.svg)](https://github.com/qmk/qmk_firmware/tags)
[![Build Status](https://travis-ci.org/qmk/qmk_firmware.svg?branch=master)](https://travis-ci.org/qmk/qmk_firmware)
[![Discord](https://img.shields.io/discord/440868230475677696.svg)](https://discord.gg/Uq7gcHh)
[![Docs Status](https://img.shields.io/badge/docs-ready-orange.svg)](https://docs.qmk.fm)
[![GitHub contributors](https://img.shields.io/github/contributors/qmk/qmk_firmware.svg)](https://github.com/qmk/qmk_firmware/pulse/monthly)
[![GitHub forks](https://img.shields.io/github/forks/qmk/qmk_firmware.svg?style=social&label=Fork)](https://github.com/qmk/qmk_firmware/)

## What is QMK Firmware?

QMK (*Quantum Mechanical Keyboard*) is an open source community centered around developing computer input devices. The community encompasses all sorts of input devices, such as keyboards, mice, and MIDI devices. A core group of collaborators maintains [QMK Firmware](https://github.com/qmk/qmk_firmware), [QMK Configurator](https://config.qmk.fm), [QMK Toolbox](https://github.com/qmk/qmk_toolbox), [qmk.fm](https://qmk.fm), and this documentation with the help of community members like you.

## Get Started

Totally new to QMK? There are two ways to get started:

* Basic: [QMK Configurator](https://config.qmk.fm)
    * Just select your keyboard from the dropdown and program your keyboard.
    * We have an [introductory video](https://www.youtube.com/watch?v=-imgglzDMdY) you can watch.
    * There is also an overview [document you can read](newbs_building_firmware_configurator.md).
* Advanced: [Use The Source](newbs.md)
    * More powerful, but harder to use

## Make It Yours

QMK has lots of [features](features.md) to explore, and a good deal of reference documentation to dig through. Most features are taken advantage of by modifying your [keymap](keymap.md), and changing the [keycodes](keycodes.md).

## Need help?

Check out the [support page](support.md) to see how you can get help using QMK.

## Give Back

There are a lot of ways you can contribute to the QMK Community. The easiest way to get started is to use it and spread the word to your friends.

* Help people out on our forums and chat rooms:
    * [/r/olkb](https://www.reddit.com/r/olkb/)
    * [Discord Server](https://discord.gg/Uq7gcHh)
* Contribute to our documentation by clicking "Edit This Page" at the bottom
* [Translate our documentation into your language](translating.md)
* [Report a bug](https://github.com/qmk/qmk_firmware/issues/new/choose)
* [Open a Pull Request](contributing.md)
